<?php

use Simulador\Tables\Vendedor;

$response = ['success' => true];

try {

    if ($_SERVER['REQUEST_METHOD'] === 'GET') {
      $vendedor = Vendedor::get($_GET['id']);

      if ($vendedor === null) {
        throw new Exception('');
      }

      $nome = $vendedor->nome;
      $telefone = $vendedor->telefone;
      $url = null;

      if (!empty($telefone)) {
        $phone = '55' . preg_replace("/\D/", "", $telefone);
        $message = urlencode("Olá $nome, gostaria de saber mais informações sobre esses 3 planos");
        $url = "https://api.whatsapp.com/send?phone=$phone&text=$message";
      }

      $response['data'] = [
        'id' => (int) $vendedor->id,
        'nome' => $nome,
        'telefone' => $telefone,
        'link' => $url,
      ];
    }

} catch (Exception $e) {
    $response['success'] = false;
    $response['message'] = ucfirst($e->getMessage());
}

echo json_encode($response, JSON_PRETTY_PRINT);
