<?php
require_once './bootstrap.php';
use Simulador\Tables\Cotacao;

$response = ['success' => true];

try {
    $data = json_decode(file_get_contents('php://input'), true);

    if ($_SERVER['REQUEST_METHOD'] === 'GET') {
        $response['data'] = Cotacao::get(['protocolo' => $_GET['id']]);
    } else if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $response = array_merge($response, Cotacao::create($data));
    } else if ($_SERVER['REQUEST_METHOD'] === 'PATCH') {
        $response = Cotacao::update($data);
    }

} catch (Exception $e) {
    $response['success'] = false;
    $response['message'] = ucfirst($e->getMessage());
}

echo json_encode($response, JSON_PRETTY_PRINT);
