<?php

/**
 * Completa a indicações que não foram salvas no moskit
 * PHP version 7.2.0
 * 
 * @category API
 * @package  Simulador
 * @author   Henrique C Madeira <henriquecm8@gmail.com>
 * @license  http://wipsites.com.br WIP
 * @link     http://simulador.proteautobrasil.com.br
 */

use Simulador\Database\DBIndicador;
use Simulador\Database\DBCotacao;
use Simulador\Tables\Indicador;

$response = ['success' => true];

try {
    
  $query = "SELECT * FROM `indicacoes` 
      WHERE `id_indicador` = '0' 
      AND time > 1596240000
      ORDER BY `time` DESC
      LIMIT 0, 1000";

  $stmt = DBIndicador::get()->prepare($query);
  if ( $stmt !== false ) {
    $stmt->execute();
    $result = $stmt->get_result();
    if ( $result !== false ) {
      $indicacoes = $result->fetch_all(MYSQLI_ASSOC);

      foreach ($indicacoes as $indicacao) {
        $id_simulacao = $indicacao['id_simulacao'];
        $response['indicacoes'][] = $id_simulacao;
        
        $query = "SELECT * FROM `cotacoes` WHERE `id` = ? AND cod_indicador != 0";

        $stmt = DBCotacao::get()->prepare($query);
        if ( $stmt !== false ) {
          $stmt->bind_param('i', $id_simulacao);
          $stmt->execute();
          $result = $stmt->get_result();
          if ( $result !== false && $result->num_rows > 0 ) {
            $cotacao = $result->fetch_assoc();

            $response['cotacoes'][] = $cotacao;
            if ($cotacao === null) {

            } else {
              /** @var string[] $cotacao */
              $cod_indicador = $cotacao['cod_indicador'];

              $response['cotacoes'][] = $cod_indicador;

              $query = "SELECT * FROM `usuarios` WHERE `link` = ?";
              $response['usuarios'][] = $cod_indicador;
            
              $stmt = DBIndicador::get()->prepare($query);
              if ( $stmt !== false ) {
                $stmt->bind_param('i', $cod_indicador);
                $stmt->execute();
                $result = $stmt->get_result();
                
                if ( $result !== false && $result->num_rows > 0) {
                  /** @var string[] $cotacao */
                  $usuario = $result->fetch_assoc();
                  $id_usuario = $cotacao['id'];

                  $query = "UPDATE `indicacoes`
                    SET `id_indicador` = ?
                    WHERE `indicacoes`.`id_simulacao` = ?";
                    
                  $stmt = DBIndicador::get()->prepare($query);
                  if ( $stmt !== false ) {
                    $stmt->bind_param('ii', $id_usuario, $id_simulacao);
                    $stmt->execute();
                    $result = $stmt->get_result();
                    if ( $result !== false ) {
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
} catch (Exception $e) {
  $response['success'] = false;
  $response['message'] = ucfirst($e->getMessage());
}

echo json_encode($response, JSON_PRETTY_PRINT);
