<?php

/**
 * Completa a indicações que não foram salvas no moskit
 * PHP version 7.2.0
 * 
 * @category API
 * @package  Simulador
 * @author   Henrique C Madeira <henriquecm8@gmail.com>
 * @license  http://wipsites.com.br WIP
 * @link     http://simulador.proteautobrasil.com.br
 */

use Simulador\Database\DBCotacao;
use Simulador\Tables\Indicador;

$response = ['success' => true];

try {
    
  $query = "SELECT *, FROM_UNIXTIME(time) as data
      FROM `cotacoes` 
      WHERE `cod_indicador` != '0' 
      ORDER BY `id` DESC
      LIMIT 100";

  $stmt = DBCotacao::get()->prepare($query);
  if ($stmt !== false) {
    $stmt->execute();
    $result = $stmt->get_result();
    if ( $result !== false ) {
      $simulacoes = $result->fetch_all(MYSQLI_ASSOC);
      $response['count'] = $result->num_rows;
      
      foreach ($simulacoes as $data) {
        $id = $data['id'];
        $time = $data['time'];
        
        $response['indicacao'][] = Indicador::create($id, $data['cod_indicador'], $time, $data['valor_adesao']);
        $response['simulacao'][] = Indicador::simulacao($id, $data, $time);
        
      }
    }
  }

} catch (Exception $e) {
  $response['success'] = false;
  $response['message'] = ucfirst($e->getMessage());
}

echo json_encode($response, JSON_PRETTY_PRINT);
