<?php

namespace Simulador\Utils;

use GuzzleHttp\Client;

class LeadsZapp
{

  private static function getClient()
  {
    $client = new Client([
      'base_uri' => "https://hub.leadszapp.com/api/v1/",
      'headers'  => [
          'X-API-KEY' => '066da08313b6892af50438645e2c364661ede22b',
      ],
    ]);

    return $client;
  }

  /**
   * @param $data
   * @return array
   */
  public static function register($data): array
  {
    $post_fields = array(
      'first_name' => $data['nome'],
      'last_name' => $data['sobrenome'] ?? '',
      'email' => $data['email'],
      'mobile_phone' => $data['ddd'] . $data['telefone'],
      'tags' => ['ngjY'],
    );

    $client = self::getClient();
    $result = $client->post('leads/register', [
      'json' => $post_fields,
    ]);

    return json_decode($result->getBody()->getContents(), true);
  }

  /**
   * @param $data
   * @return bool
   */
  public static function sendMessage($data): bool
  {
    $client = self::getClient();
    $response = $client->post('whatsapp/send', [
      'json' => $data,
    ]);
    
    $result = json_decode($response->getBody()->getContents(), true);
    
    return  (isset($result['result']) && $result['result']);
  }
}
