<?php

namespace Simulador\Tables;

use NilPortugues\Sql\QueryBuilder\Builder\MySqlBuilder;
use PDO;
use Simulador\Database\DBCotacao;
use Simulador\Models\VendedorModel;

class Vendedor extends VendedorModel
{

  /**
   * @param int $id
   * @return self|null
   */
  public static function get(int $id): ?Vendedor
  {
    $builder = new MySqlBuilder();
    $select = $builder->select('vendedores');
    $select->where()->equals('id', $id);

    $query = $builder->write($select);
    $values = $builder->getValues();

    $stmt = DBCotacao::getPDO()->prepare($query);
    $stmt->execute($values);

    if ($stmt->rowCount() > 0) {
      $data = $stmt->fetch(PDO::FETCH_ASSOC);
      return self::fromArray($data);
    }
    return null;
  }

}
