<?php

namespace Simulador\Tables;

use Exception;
use GuzzleHttp\Client;

class Simulacao
{

  /**
   * @param array $data
   * @return mixed
   * @throws Exception
   */
  public static function get(array $data)
  {
    $client = new Client(['base_uri' => "https://sis.proteautobrasil.com.br/api/v1/"]);

    if(!isset($data['valor'])) {
      throw new Exception("O valor da simulação deve ser informado.");
    }

    if(isset($data['tipo']) && (int) $data['tipo'] !== 3) {
      throw new Exception("Não oferecemos cobertura para este tipo de veículo.");
    }

    $response = $client->get('fipe/tabela.php', [
      'query' => [
        'valor' => $data['valor'],
        'time' => time(),
      ]
    ]);

    $data = json_decode($response->getBody()->getContents(), true);
    $tabela = $data['tabela'];
    $adesao = (float)$data['adesao'];
    $vitalicio = 92;
    $mensal = ((float)$tabela['0.32']) + $vitalicio;

    $data = [
      'corretora' => [
        'nome' => 'Proteauto Brasil',
        'telefone' => '44991232477',
        'endereco' => '',
      ],
      'plano' => [
        'nome' => 'Plano Prata',
        'valorMensal' => $mensal,
        'valorAdesao' => $adesao,
        'valorAnual' => round($mensal * 12 * 100) / 100,
      ],
      'itensPlano' => [
        [
          'isIncluso' => true,
          'id' => 1,
          'tag' => 'colisao',
          'nome' => 'Colisão',
          'descricao' => 'Nossa cobertura contra colisões irá garantir que, ao caso de sinistro, você consiga consertar seu veículo no menor tempo possível, em uma das nossas oficinas credenciadas, com o menor esforço e no menor tempo possível. Todos os nossos profissionais estão empenhados em ajudá-lo minimizando suas frustrações.',
          'observacao' =>
            "*Qualquer Batida: ".
            "Em caso de colisões, você poderá contar, através da nossa central 24h, com nosso serviço de reboque, transporte para retirada do veículo, destombamento, transmissão de mensagens, retorno a domicílio, remoção inter hospitalar e até mesmo com nosso serviço de táxi. ".
            "Perda Total: ",
            "Em caso de perda total em batidas, tombamento, queda de veículo ou queda de qualquer objeto que cause a perda total do seu veículo, essa cobertura garante que você receba o valor que contratou da proteção.",
        ],
        [
          'isIncluso' => true,
          'id' => 2,
          'tag' => 'incendio',
          'nome' => 'Incêndio',
          'descricao' => 'Se seu veículo der perda total porque pegou fogo, explodiu, ou caiu um raio, você recebe o valor da fipe ou reposição do bem para compensar o prejuízo.',
          'observacao' => '',
        ],
        [
          'isIncluso' => true,
          'id' => 3,
          'tag' => 'roubo',
          'nome' => 'Roubo ou Furto',
          'descricao' => 'A Proteauto oferece a cobertura contra roubo ou furto*, que visa proteger o patrimônio de todos os nossos associados, tão duramente conquistado. Se não for localizado você recebe o valor integral do seu veículo!**',
          'observacao' => '',
        ],
        [
          'isIncluso' => true,
          'id' => 4,
          'tag' => 'assistencia',
          'nome' => 'Assistências 24h',
          'descricao' => 'Em caso de pane elétrica ou mecânica no seu veículo, você pode acionar até 1 assistência por mês, e em caso de acidente 0 km é ilimitado',
          'observacao' => 'Registro de CNVR, Retorno ao domicílio, Translado de corpos, Transmissão de Mensagens, Reboque 300km, Socorro Elétrica, Pane Mecânica, Chaveiro, Envio de acompanhante, Remoção inter hospitalar',
        ],
        [
          'isIncluso' => true,
          'id' => 5,
          'tag' => 'rastreador',
          'nome' => 'Rastreador',
          'descricao' => 'Se seu veículo estiver acima de 95 mil reais, você ganha um rastreador sem custo mensal para monitorar ele onde estiver, e além disso você terá acesso via login e senha no aplicativo.',
          'observacao' => '',
        ],
        [
          'isIncluso' => true,
          'id' => 6,
          'tag' => 'agregado',
          'nome' => 'Cobertura de Agregado / Implementos',
          'descricao' => 'Essa cobertura é exclusiva para veículos de carga, criada para você que tem seu caminhão rodando por todo Brasil e busca por uma cobertura mais completa para não deixar nada de fora, seja um 4° eixo, equipamento de guincho, uma carroceria ou até mesmo uma carreta, poderá contratar mais essa cobertura para deixar seu bruto bem protegido.',
          'observacao' => '',
        ],
        [
          'isIncluso' => true,
          'id' => 7,
          'tag' => 'destombamento',
          'nome' => 'Destombamento',
          'descricao' => 'A gente sabe que não podemos contar sempre com a sorte e por vários motivos um veículo pode vir a tombar ou até mesmo capotar, com essa cobertura você garanta que se isso acontecer todas as despesas ficam por conta da Proteauto.',
          'observacao' => '',
        ],
        [
          'isIncluso' => true,
          'id' => 8,
          'tag' => 'condutor',
          'nome' => 'Sem perfil de condutor',
          'descricao' => 'Nossa proteção é totalmente desburocratizada e não trabalhamos com perfil de condutor, é isso mesmo, você não precisa ficar informando sempre quem é o condutor, desde que o mesmo esteja habilitado para conduzir o veículo.',
          'observacao' => '',
        ],
        [
          'isIncluso' => true,
          'id' => 9,
          'tag' => 'nacional-24h',
          'nome' => 'Cobertura nacional 24h',
          'descricao' => 'Aqui na Proteauto além de um atendimento humanizado, nós te damos uma cobertura completa em todo território nacional sem restrição de horários ou rota, porque sabemos que para o trabalho não existe hora marcada nem rota certa.',
          'observacao' => '',
        ],
      ],
      'infoAdicionais' => [
        [
          'id' => 1,
          'descricao' => 'O valor da mensalidade será cobrada mês a mês por boleto bancário.',
        ],
        [
          'id' => 2,
          'descricao' => 'A cobertura será ativa em até 24h (após o cadastro ser aprovado).',
        ],
        [
          'id' => 3,
          'descricao' => "O valor da sua adesão será R$ " . number_format($adesao, 2, ',', '.') . " (Cobrado uma única vez).",
        ],
        [
          'id' => 4,
          'descricao' => 'Um consultor entrará em contato para assinatura dos termos de adesão e agendamento da vistoria.',
        ],
      ],
      'itensOpcionais' => [
        [
          'id' => 1,
          'título' => 'Cobertura de Terceiros',
          'itens' => [
            [
              'id' => 1,
              'descricao' => 'Sem Cobertura',
              'valor' => 0,
            ],
            [
              'id' => 2,
              'descricao' => 'R$ 50.000,00',
              'valor' => 120,
            ],
            [
              'id' => 3,
              'descricao' => 'R$ 100.000,00',
              'valor' => 180,
            ],
            [
              'id' => 4,
              'descricao' => 'R$ 150.000,00',
              'valor' => 200,
            ],
            [
              'id' => 5,
              'descricao' => 'R$ 200.000,00',
              'valor' => 230,
            ],
            [
              'id' => 6,
              'descricao' => 'R$ 250.000,00',
              'valor' => 250,
            ],
            [
              'id' => 7,
              'descricao' => 'R$ 300.000,00',
              'valor' => 280,
            ],
            [
              'id' => 8,
              'descricao' => 'R$ 400.000,00',
              'valor' => 310,
            ],
          ],
        ]
      ],
    ];

    return $data;
  }

}
