<?php

namespace Simulador\Tables;

use Simulador\Database\DBIndicador;

class Indicador
{

    public static function create($id, $indicador, $time, $valor_adesao)
    {

        $query = "INSERT INTO `indicacoes`
            (`id_simulacao`, `id_indicador`, `situacao`, `situacao_moskit`, `situacao_comissao`, `situacao_perdeu`, `valor_adesao`, `time`, `checkout`)
        VALUES
            (?, (SELECT id FROM usuarios WHERE link = ? LIMIT 1), 'pendente', null, null, '', ?,?,(SELECT `checkout` FROM usuarios WHERE link = ? LIMIT 1))";

        $stmt = DBIndicador::get()->prepare($query);
        $stmt->bind_param('iiidi', $id, $indicador, $valor_adesao, $time, $indicador);
        $stmt->execute();
        return $stmt->insert_id;
    }

    public static function simulacao($id, $data, $time):void
    {

        $query = "REPLACE INTO `simulacoes` 
            (`id`, `nome`,  `email`, `ddd`, `telefone`,
             `marca`, `modelo`, `ano`, `combustivel`, 
             `fipe_codigo`, `valor_fipe`, `valor_adesao`, `time`)
        VALUES
            (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $stmt = DBIndicador::get()->prepare($query);
        $stmt->bind_param('issiississidi',
            $id, $data['nome'], $data['email'], $data['ddd'], $data['telefone'],
            $data['marca'], $data['modelo'], $data['ano'], $data['combustivel'],
            $data['fipe_codigo'], $data['valor_fipe'], $data['valor_adesao'], $time);
        $stmt->execute();
        
    }

}
