<?php

namespace Simulador\Tables;

use Simulador\Database\DBCotacao;
use Simulador\Models\CronModel;
use Simulador\Utils\LeadsZapp;
use Simulador\Utils\Twig;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Error\SyntaxError;

class Cron extends CronModel
{

  public static function schedule($protocolo, $indicador = null): bool
  {

    $time = time();

    $cliente_primeira = strtotime('+1 minutes');
    $cliente_segunda = strtotime('+6 minutes');
    $cliente_terceira = strtotime('+21 minutes');
    $cliente_quarta = strtotime('+31 minutes');
    $indicador_primeira = strtotime('+1 minutes');
    $indicador_segunda = strtotime('+3 minutes');

    $query = 'INSERT INTO `agenda_mensagens` '
      . '(tipo,  protocolo, data_envio, status, time ) VALUES '
      . "('first',  $protocolo, $cliente_primeira, 0 ,$time), "
      . "('second', $protocolo, $cliente_segunda,  0 ,$time), "
      . "('third',  $protocolo, $cliente_terceira, 0 ,$time), "
      . "('fourth', $protocolo, $cliente_quarta,   0 ,$time)";

    // if (isset($indicador)) {
    //   $time = time();

    //   $query .= ", ('indicador_first', $protocolo, $indicador_primeira, 0 ,$time), " .
    //     "('indicador_second', $protocolo, $indicador_segunda, 0 ,$time)";
    // }

    DBCotacao::get()->query($query);

    return true;
  }

  public static function getPending(): void
  {
    $query = 'SELECT * FROM `agenda_mensagens` WHERE `status` = 0 AND `data_envio` < UNIX_TIMESTAMP() LIMIT 0, 100';

    $result = DBCotacao::get()->query($query);

    if ($result->num_rows > 0) {
      while ($row = $result->fetch_assoc()) {
        if (strpos($row['tipo'], 'indicador') === false) {
          self::messageCliente($row);
        }
      }
    }
  }

  public static function messageCliente($data): void
  {

    try {
      $query = "SELECT * FROM `cotacoes` WHERE `time` = {$data['protocolo']}";
      $result = DBCotacao::get()->query($query);
      if ($result->num_rows > 0) {

        $cotacao = $result->fetch_assoc();

        $nome = $cotacao['nome'];
        $sobrenome = $cotacao['sobrenome'];
        $email = $cotacao['email'];
        $ddd = $cotacao['ddd'];
        $telefone = $cotacao['telefone'];

        $cotacao['valor_mensalidade'] = (float)$cotacao['valor_mensalidade'];
        $cotacao['valor_cobertura'] = (float)$cotacao['valor_cobertura'];

        $cotacao['anual'] = ($cotacao['valor_mensalidade'] * 12) + (($cotacao['valor_cobertura'] * 12) * 15 / 100 - ($cotacao['valor_cobertura'] * 12));

        $twig = Twig::get();
        $template = $twig->load("/{$data['tipo']}.twig");
        $content = $template->render($cotacao);

        $post = [
          'bot' => 221,
          'contact' => [
            'first_name' => $nome,
            'last_name' => $sobrenome,
            'email' => $email,
            'mobile_phone' => '55' . $ddd . $telefone,
          ],
          'messages' => [
            $content,
          ],
        ];

        $result = LeadsZapp::sendMessage($post);

        if ($result) {
          $query = "UPDATE `agenda_mensagens` SET `status` = 1 WHERE `id` = ?";
          $stmt = DBCotacao::get()->prepare($query);
          $stmt->bind_param('i', $data['id']);
          $stmt->execute();
        }
      }
    } catch (LoaderError | RuntimeError | SyntaxError $e) {
    }
  }
}
