<?php

namespace Simulador\Tables;

use Exception;
use NilPortugues\Sql\QueryBuilder\Builder\MySqlBuilder;
use NilPortugues\Sql\QueryBuilder\Manipulation\Insert;
use NilPortugues\Sql\QueryBuilder\Manipulation\Update;
use PDO;
use Simulador\Database\DBCotacao;
use Simulador\Models\CotacaoModel;
use Simulador\Moskit\Deal;
use Simulador\Utils\Facebook;
use Simulador\Utils\LeadsZapp;
use Throwable;

class Cotacao extends CotacaoModel
{

  /**
   * @param array $data
   * @return mixed
   * @throws Exception
   */
  public static function get(array $data)
  {
    $builder = new MySqlBuilder();
    $select = $builder
      ->select('cotacoes');
    $where = $select
      ->where();

    if (isset($data['protocolo'])) {
      $where->equals('protocolo', $data['protocolo']);
    } else if (isset($data['id'])) {
      $where->equals('id', $data['id']);
    } else {
      throw new Exception('missing-id');
    }

    $query = $builder->write($select);
    $values = $builder->getValues();

    $stmt = DBCotacao::getPDO()->prepare($query);
    $stmt->execute($values);

    if ($stmt->rowCount() > 0) {
      return $stmt->fetch(PDO::FETCH_ASSOC);
    }
    throw new Exception('unknown-id');
  }

  public static function create($data = []): array
  {
    $time = time();

    $cotacao = [
      'protocolo' => $time,
      'time' => $time,
      'ip' => getClientIP(),
    ];

    foreach ($data as $key => $value) {
      if (property_exists(new self(), $key)) {
        $cotacao[$key] = $value;
      }
    }

    $builder = new MySqlBuilder();
    /** @var Insert $insert */
    $insert = $builder->insert('cotacoes');
    $insert->setValues($cotacao);

    $query = $builder->write($insert);
    $values = $builder->getValues();

    $stmt = DBCotacao::getPDO()->prepare($query);
    $stmt->execute($values);

    $id = DBCotacao::getPDO()->lastInsertId();

    $numero = $data['ddd'] . $data['telefone'];

    $response = [
      'id' => (int)$id,
      'protocolo' => $time,
    ];

    if (!empty($data['cod_indicador'])) {
      $response['id_indicacao'] =  Indicador::create($id, $data['cod_indicador'], $time, $data['valor_adesao']);
      Indicador::simulacao($id, $data, $time);
    }

    if (!empty($data['vendedor'])) {
      $vendedor = Vendedor::get($data['vendedor']);
      $response['vendedor'] = $vendedor;
    }

    if (isset($vendedor)) {
      $response['deal'] = Deal::post($data, $vendedor);
    } else {
      LeadsZapp::register($cotacao);
      Cron::schedule($time, $data['cod_indicador']);
      SMS::send(self::getCreateMessage($cotacao), $numero);
    }
    Encurtador::create($time);

    try {
      $data['id'] = $id;
//      $response['pixel'] = Facebook::pageView($data);
    } catch (Throwable $e) {
      $response['pixel'] = $e->getMessage();
    }

    return $response;
  }

  public static function getCreateMessage($data): string
  {
    $nome = explode(' ', $data['nome'])[0];
    $time = $data['time'];

    return "Olá, $nome ;) Falta pouco para sua proteção ficar pronta. "
      . 'Termine sua simulação e fale com um consultor online '
      . "prote.me/$time";
  }

  public static function update($data = [])
  {
    if (!empty($data['id'])) {
      $cotacao = [];
      foreach ($data as $key => $value) {
        if (property_exists(new self(), $key)) {
          $cotacao[$key] = $value;
        }
      }

      $builder = new MySqlBuilder();

      /** @var Update $update */
      $update = $builder->update();
      $update->setTable('cotacoes')
      ->setValues($cotacao)
        ->where()
        ->equals('id', $data['id']);

      $query = $builder->write($update);
      $values = $builder->getValues();

      $stmt = DBCotacao::getPDO()->prepare($query);

      return $stmt->execute($values);
    } else {
      return false;
    }
  }
}
