<?php

namespace Simulador\Moskit;

use GuzzleHttp\Exception\ClientException;
use GuzzleHttp\Exception\GuzzleException;
use Simulador\Tables\Vendedor;
use Throwable;

class Deal
{

  /**
   * @param array $dados
   * @param Vendedor $vendedor
   * @return array|bool
   */
  public static function post(array $dados, Vendedor $vendedor)
  {
    $contact = Contact::post($dados, $vendedor);
    if ($contact === false) {
      return false;
    }

    $deal = [
      'name' => $dados['nome'],
      'status' => 'OPEN',
      'stage' => [
        'id' => (int) $vendedor->etapa,
      ],
      'createdBy' => [
        'id' => (int) $vendedor->usuario,
      ],
      'responsible' => [
        'id' => (int) $vendedor->usuario,
      ],
      'contacts' => [[
        'id' => (int) $contact['id'],
      ]],
      'entityCustomFields' => [
        [
          'id' => $vendedor->campo_marca,
          'textValue' => $dados['marca'],
        ], [
          'id' => $vendedor->campo_modelo,
          'textValue' => $dados['modelo'],
        ], [
          'id' => $vendedor->campo_ano,
          'textValue' => $dados['ano'],
        ], [
          'id' => $vendedor->campo_valor,
          'textValue' => 'R$ '. number_format($dados['valor_fipe'], 2, ',', '.'),
        ], [
          'id' => $vendedor->campo_fipe,
          'textValue' => $dados['fipe_codigo'],
        ],
      ],
    ];

    try {
      $client = MoskitAPI::getClient($vendedor->api_key);
      $response = $client->post('deals/', [
        'json' => $deal,
      ]);
      $body = $response->getBody();
      $content = json_decode($body, true);

    } catch (ClientException $e) {
      error_log($e->getResponse()->getBody()->getContents());
      return false;
    } catch (Throwable $e) {
      error_log($e->getMessage());
      return false;
    }

    return $content;
  }

}
